<?php
    
  if (!defined("_VALID_PHP_8-1"))
      die('Direct access to this location is not allowed.');
  
  class Products
  {
      
	  public $prod_id = null;
	  public $slug = null;
      public $_url;
	  public $homeid = null;
	  private static $db;
	  
	  const catTable = "ccategories";
	  const lgTable = "language";
	  const prdTable = "pprods";
	  const pvarTable = "pvariations";
	  const popTable = "poptions";
	  const pmoreTable = "pmore";
	  
      /**
       * Content::__construct()
       * 
       * @return
       */
	  public function __construct()
	  {
		  $this->_getUrl();
		  self::$db = Registry::get("Database");
	  }
      
	  protected function _getUrl()
	  {
		  $url = isset($_GET['url']) ? rtrim($_GET['url'], '/') : null;
		  $url = sanitize($url);
		  $this->_url = explode('/', $url);
	  }
	  
      
	  public function getProducts($paginate = false)
	  {
		  $pager = Paginator::instance();
		  if($pager->current_cat){
			  $where ="pparent"; $what = $pager->current_cat; 
			  $counter = countEntries(self::prdTable,$where,$what);
		  }else{
			  $counter = countEntries(self::prdTable);
		  }
		  $pager->items_total = $counter;
		  $pager->default_ipp = Registry::get("Core")->perpage;
		  $pager->paginate();
		  $limit = ($paginate) ? $pager->limit : null;
		  ($pager->current_cat) ? $where =" where pparent=".$pager->current_cat." " : $where="";
		  $sql = "SELECT *, UNIX_TIMESTAMP(padd_date) as pdate, UNIX_TIMESTAMP(pupdate_date) as pupdate FROM " . self::prdTable
		  . "\n ".$where."ORDER BY pid" . $limit;
          $row = self::$db->fetch_all($sql);
          
		  return ($row) ? $row : 0;
		}
		
		
		
		
		
		public function getfrontProducts($catid,$paginate = false)
	  {
		  $pager2 = Paginator2::instance2();
          $pager2->current_cat = $catid;
		  $pager2->current_page = getFlyPG();
		  $where ="pparent"; $what = $pager2->current_cat; 
		  $counter = countEntries(self::prdTable,$where,$what);
		  $pager2->items_total = $counter;
		  $pager2->default_ipp = Registry::get("Core")->perpage;
		  $pager2->paginate();
		  $limit = ($paginate) ? $pager2->limit : null;
		  $where =" where pparent=".$pager2->current_cat." and pvisible='Yes' ";
		  $sql = "SELECT * FROM " . self::prdTable
		  . "\n ".$where."ORDER BY pid desc" . $limit;
          $row = self::$db->fetch_all($sql);
          
		  return ($row) ? $row : 0;
		}
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		public function getFeaturedProducts($paginate = false)
	  {
		  $pager = Paginator::instance();
		  $where ="pfeature"; $what = "Yes"; 
		  $counter = countEntries(self::prdTable,$where,$what);
		  
		  $pager->items_total = $counter;
		  $pager->default_ipp = Registry::get("Core")->perpage;
		  $pager->paginate();
		  $limit = ($paginate) ? $pager->limit : null;
		  $where =" where pfeature='Yes' ";
		  $sql = "SELECT * FROM " . self::prdTable
		  . "\n ".$where."ORDER BY pfeature_r " . $limit;
          $row = self::$db->fetch_all($sql);
          
		  return ($row) ? $row : 0;
		}
		
		
		
		
		
		public function getPrdMore($paginate = false)
	  	{
		  
		  $pager = Paginator::instance();
		  if($pager->current_cat){
			  $where ="pid"; $what = $pager->current_cat; 
			  $counter = countEntries(self::pmoreTable,$where,$what);
		  }else{
			  $counter = countEntries(self::pmoreTable);
		  }
		  
		  $pager->items_total = $counter;
		  $pager->default_ipp = Registry::get("Core")->perpage;
		  $pager->paginate();
		  $limit = ($paginate) ? $pager->limit : null;
		  ($pager->current_cat) ? $where =" where pid=".$pager->current_cat." " : $where="";
		  $sql = "SELECT *, UNIX_TIMESTAMP(mcreated) as mdate, UNIX_TIMESTAMP(mupdated) as mupdate FROM " . self::pmoreTable
		  . "\n ".$where."ORDER BY mid " . $limit;
          $row = self::$db->fetch_all($sql);
          
		  return ($row) ? $row : 0;
		}
		
		
		
		
		public function getVariations($paginate = false)
	  {
		  $pager = Paginator::instance();
		  if($pager->current_cat){
			  $where ="vparent"; $what = $pager->current_cat; 
			  $counter = countEntries(self::pvarTable,$where,$what);
		  }else{
			  $counter = countEntries(self::pvarTable,"vparent","0");
		  }
		  $pager->items_total = $counter;
		  $pager->default_ipp = Registry::get("Core")->perpage;
		  $pager->paginate();
		  $limit = ($paginate) ? $pager->limit : null;
		  ($pager->current_cat) ? $where =" where vparent=".$pager->current_cat." " : $where=" where vparent=0 ";
		  $sql = "SELECT *, UNIX_TIMESTAMP(vcreated) as vdate, UNIX_TIMESTAMP(vupdated) as vupdate FROM " . self::pvarTable
		  . "\n ".$where."ORDER BY vid" . $limit;
          $row = self::$db->fetch_all($sql);
          
		  return ($row) ? $row : 0;
		}
		
		
		
		
		
		
		/**
	   * Content::getPageList()
	   * 
	   * @return
	   */
	  public static function getPrdVarList($selected = false)
	  {
	
		  $sql = "SELECT * FROM " . self::pvarTable." where vparent=0 order by vsort";
		  $result = self::$db->fetch_all($sql);
	
		  $option = "";
		  if ($result) {
			  $option .= "<option  value=\"\">All Variations</option>";
			  foreach ($result as $row) {
				  $sel = ($row->vid == $selected) ? "selected=\"selected\"" : null;
$option .= ($row->vid == $selected) ? "<option value=\"".$row->vid."\" ".$sel.">".$row->vname."</option>\n" : "<option value=\"".$row->vid."\">".$row->vname."</option>\n";
				  
				}
	
			 
		  }else{
			}
		  return $option;
	
	  } 
	  
	  
	  
	  /**
	   * Content::getPageList()
	   * 
	   * @return
	   */
	  public static function getPrdVarList2($selected = false)
	  {
	
		  $sql = "SELECT vid, vname FROM " . self::pvarTable." where vparent=0 order by vsort";
		  $result = self::$db->fetch_all($sql);
	
		  $display = '';
		  if ($result) {
			  $display .= "<select name=\"vparent\">";
			  $display .= "<option value=\"0\">Root Variation</option>\n";
			  foreach ($result as $row) {
				  $sel = ($row->vid == $selected) ? ' selected="selected"' : null;
				  $display .= "<option value=\"" . $row->vid . "\"" . $sel . ">" . $row->vname . "</option>\n";
				}
	
			  $display .= "</select>\n";
		  }else{
			  
			  $display .= "<select name=\"vparent\">";
			  $display .= "<option value=\"0\">Root Variation</option>\n";
			  $display .= "</select>\n";
		  }
		  return $display;
	
	  }  
	  
	  
	  
	   
	  
	  
	  
	  
	  
	  
	  public function getvarParent($parent = 0)
		{
		if(!$parent==0){
		$sql = "SELECT vname FROM " . self::pvarTable
		. "\n where vid='".$parent."' limit 1";
		$row = self::$db->fetch_all($sql);
		foreach ($row as $ggg):
		$cparent = getValue("vparent","pvariations","vid=".$parent);
		$cname = "<a class=\"cyan-text tooltip\" data-position=\"top\" data-delay=\"10\" data-tooltip=\"View Parent Variation\" href=\"pvariation.php?cat=".$cparent."\">".$ggg->vname."</a>";
		endforeach;
		}else{
		$cname = "Root";  
		}
		return $cname;
		}
		
		
		
		
		public function getvarVisible($parent = 0)
		{
		
		$sql = "SELECT vvisible FROM " . self::pvarTable
		. "\n where vid='".$parent."' limit 1";
		$row = self::$db->fetch_all($sql);
		foreach ($row as $ggg):
		$cname = $ggg->vvisible;
		if($cname=="Yes"){
		$scname = '<button type="submit" name="active" value="Yes" class="task-cat green tooltip" data-position="top" data-delay="10" data-tooltip="Disable?">'.$cname.'</button>';	
		}else{
		$scname = '<button type="submit" name="active" value="No" class="task-cat red tooltip" data-position="top" data-delay="10" data-tooltip="Enable?">'.$cname.'</button>';	
		}
		endforeach;
		return $scname;
		}
		
		
		
		
		
		
		
		public function getPrdList($selected = false)
		{
		
		$sql = "SELECT * FROM " . self::prdTable." order by pid";
		$result = self::$db->fetch_all($sql);
		
		$option = "";
		$option .= "<option  value=\"\">All More Views</option>";
		if ($result) {
		foreach ($result as $row) {
		$sel = ($row->pid == $selected) ? "selected=\"selected\"" : null;
		$option .= ($row->pid == $selected) ? "<option value=\"".$row->pid."\" ".$sel.">".$row->pname." (".$row->part.")</option>\n" : "<option value=\"".$row->pid."\">".$row->pname." (".$row->part.")</option>\n";
		
		}
		}
		return $option;
		}
		
		
		
		
		
		
		
		
		/**
	   * Content::getPageList()
	   * 
	   * @return
	   */
	  public static function getPrdList2($selected = false)
	  {
	
			$sql = "SELECT * FROM " . self::prdTable." order by pid";
			$result = self::$db->fetch_all($sql);
	
		  $display = '';
		  if ($result) {
			  $display .= "<select name=\"pid\">";
			  $display .= "<option value=\"0\">All Products</option>\n";
			  foreach ($result as $row) {
				  $sel = ($row->pid == $selected) ? ' selected="selected"' : null;
				  $display .= "<option value=\"" . $row->pid . "\"" . $sel . ">" . $row->pname."(".$row->part.")</option>\n";
				}
	
			  $display .= "</select>\n";
		  }else{
			  
			  $display .= "<select name=\"pid\">";
			  $display .= "<option value=\"0\">All Products</option>\n";
			  $display .= "</select>\n";
		  }
		  return $display;
	
	  }  
		
		
		
		
		
		
		
		
		public function getpmoreVisible($what,$parent = 0)
		{
		
		$sql = "SELECT ".$what." FROM " . self::pmoreTable
		. "\n where mid='".$parent."' limit 1";
		$row = self::$db->fetch_all($sql);
		foreach ($row as $ggg):
		$cname = $ggg->$what;
		if($cname=="Yes"){
		$scname = '<button type="submit" name="active" value="Yes" class="task-cat green tooltip" data-position="top" data-delay="10" data-tooltip="Disable?">'.$cname.'</button>';	
		}else{
		$scname = '<button type="submit" name="active" value="No" class="task-cat red tooltip" data-position="top" data-delay="10" data-tooltip="Enable?">'.$cname.'</button>';	
		}
		endforeach;
		return $scname;
		}
		
		
		
		
		
		
		
		public function getprdVisible($what,$parent = 0)
		{
		
		$sql = "SELECT ".$what." FROM " . self::prdTable
		. "\n where pid='".$parent."' limit 1";
		$row = self::$db->fetch_all($sql);
		foreach ($row as $ggg):
		$cname = $ggg->$what;
		if($cname=="Yes"){
		$scname = '<button type="submit" name="active" value="Yes" class="task-cat green tooltip" data-position="top" data-delay="10" data-tooltip="Disable?">'.$cname.'</button>';	
		}else{
		$scname = '<button type="submit" name="active" value="No" class="task-cat red tooltip" data-position="top" data-delay="10" data-tooltip="Enable?">'.$cname.'</button>';	
		}
		endforeach;
		return $scname;
		}
		
		
		
		
		/**
	   * Content::getPageList()
	   * 
	   * @return
	   */
	  public static function getPrdVarOptions($selected = false)
	  {
          $sel2 = null;
		  $sql = "SELECT vid, vname FROM " . self::pvarTable." where vparent=0 order by vsort";
		  $result = self::$db->fetch_all($sql);
	
		  $display = '';
		  if ($result) {
			  $display .= "<div class=\"row\" style=\"margin-top:30px;\">\n";
			  foreach ($result as $row) {
				  	$display .= "<div class=\"col s12 m6\">\n";
					$display .= "<p>".$row->vname.":</p>\n";
					$sql2 = "SELECT vid, vname FROM " . self::pvarTable ." where vparent=".$row->vid." order by vsort";
					$result2 = self::$db->fetch_all($sql2);
					if($result2){
					foreach ($result2 as $row2) {
						
						if($selected){
						$sidd = "pvar".$row2->vid."_".$selected;
						if(Registry::get("Database")->numrows(Registry::get("Database")->query("select psid from psvariations where psub=".$row2->vid." and pid=".$selected."")) >0){
						$sel2 = "checked=\"checked\"";
						}else{$sel2 = null;}
						}else{$sidd = "pvar".$row2->vid;}
						
						$display .= "<p style=\"display:inline-block; margin:0 10px;\"><input name=\"pvar[]\" value=\"".$row2->vid."\" type=\"checkbox\" ".$sel2." class=\"filled-in\" id=\"".$sidd."\">
						<label style=\"padding-left:25px\" for=\"".$sidd."\">".$row2->vname."</label></p>\n";
					}
					}
					$display .= "</div>\n";
				}
	
			  $display .= "</div>\n";
		  }else{}
		  return $display;
	
	  } 
	  
	  
	  
	  
	  
	  public static function getPrdVarOptions2($cid,$selected = false)
	  {
          $sel2 = null;
		  $sql = "SELECT vid, vname FROM " . self::pvarTable." where vparent=0 order by vsort";
		  $result = self::$db->fetch_all($sql);
	
		  $display = '';
		  if ($result) {
			  $display .= "<div class=\"row\" style=\"margin-top:30px;\">\n";
			  foreach ($result as $row) {
				  	$display .= "<div class=\"col s12 m6\">\n";
					$display .= "<p>".$row->vname.":</p>\n";
					$sql2 = "SELECT vid, vname FROM " . self::pvarTable ." where vparent=".$row->vid." order by vsort";
					$result2 = self::$db->fetch_all($sql2);
					if($result2){
					foreach ($result2 as $row2) {
						
						if($selected){
						$sidd = "pvar".$row2->vid."_".$selected;
						if(Registry::get("Database")->numrows(Registry::get("Database")->query("select psid from psvariations where psub=".$row2->vid." and pid=".$selected."")) >0){
						$sel2 = "checked=\"checked\"";
						}else{$sel2 = null;}
						}else{$sidd = "pvar".$row2->vid;}
						
						$display .= "<p style=\"display:inline-block; margin:0 10px;\"><input name=\"pvar[]\" value=\"".$row2->vid."\" type=\"checkbox\" ".$sel2." class=\"filled-in\" id=\"".$sidd."_".$cid."\"><label style=\"padding-left:25px\" for=\"".$sidd."_".$cid."\">".$row2->vname."</label></p>\n";
					}
					}
					$display .= "</div>\n";
				}
	
			  $display .= "</div>\n";
		  }else{}
		  return $display;
	
	  } 
		
		
		
		
		
		
/*
$sql2 = "SELECT cid, cname" . Lang::$lang . " FROM " . self::catTable ." where cparent=".$row->cid." order by csort";
				  $result2 = self::$db->fetch_all($sql2);
				  if($result2){
					foreach ($result2 as $row2) {
					$sel2 = ($row2->cid == $selected) ? ' selected="selected"' : null;
					$display .= "<option value=\"" . $row2->cid . "\"" . $sel2 . ">2nd-> " . $row2->{'cname' . Lang::$lang} . "</option>\n";
                    
                    
<div class="row" style="margin-top:30px;">
<div class="col s12">
<h4 class="header2">Sizes:</h4>
<p style="display:inline-block; margin:0 10px;"><input type="checkbox" class="filled-in" id="small" checked="checked"><label style="padding-left:25px" for="small">Small</label></p>
<p style="display:inline-block; margin:0 10px;"><input type="checkbox" class="filled-in" id="medium" checked="checked"><label style="padding-left:25px" for="medium">Medium</label></p>
<p style="display:inline-block; margin:0 10px;"><input type="checkbox" class="filled-in" id="large" checked="checked"><label style="padding-left:25px" for="large">Large</label></p>
<p style="display:inline-block; margin:0 10px;"><input type="checkbox" class="filled-in" id="x-large" checked="checked"><label style="padding-left:25px" for="x-large">X-Large</label></p>
<p style="display:inline-block; margin:0 10px;"><input type="checkbox" class="filled-in" id="xx-large" checked="checked"><label style="padding-left:25px" for="xx-large">XX-Large</label></p>
</div>
</div>
*/		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
  }
?>